/**
* \file: VideoChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_VIDEOCHANNEL_H
#define CARPLAY_VIDEOCHANNEL_H

#include "Common.h"
#include "AirPlayHeaders.h"
#include "IVideoOutAdapter.h"
#include "FrameInternal.h"
#include "Session.h"
#include "utils/PoolTemplate.h"
#include "utils/Referencable.h"

namespace adit { namespace carplay
{

class CARPLAY_HIDDEN VideoChannel : public Referencable<VideoChannel, ScreenStreamRef>,public IVideoReceiver
{
public:
    VideoChannel();
    ~VideoChannel();
    inline Session* GetSession() { return session; }

    bool Initialize(Session* session, IConfiguration* config);
    bool Start();
    void Stop();
    void RenderScreen(const uint8_t* inData, size_t inLen, uint64_t inDisplayTicks,
            CFDictionaryRef inOptions, ScreenStreamCompletion_f inCompletion, void* inContext);
    void Finish();
    void FirstFrameRendered();

private:
    size_t GetNextPowerOfTwo(size_t curLen);
    static std::map<const ScreenStreamRef, VideoChannel*> map;
    Session* session;
    std::unique_ptr<IVideoOutAdapter> mainScreen;
    bool currentFrameValid;
    bool isNewframe;

    FrameInternal* frame;

    pthread_mutex_t videoMutex;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_VIDEOCHANNEL_H */
